import type { Metadata } from "next";
import { Inter } from "next/font/google";
import "./globals.css";
import Header from "@/components/Header";
import Footer from "@/components/Footer";

const inter = Inter({ subsets: ["latin"] });

export const metadata: Metadata = {
  title: "SAAM Cabins - Porta Cabin Solutions UAE",
  description: "Leading porta cabin manufacturer and supplier in UAE. Office cabins, security cabins, toilet units and custom solutions. Manufacturing facility in Sharjah with UAE-wide delivery.",
  keywords: ["porta cabin UAE", "office cabin", "security cabin", "toilet units", "portable buildings", "Sharjah manufacturing", "UAE cabin supplier"],
  authors: [{ name: "SAAM Cabins" }],
  openGraph: {
    title: "SAAM Cabins - Porta Cabin Solutions UAE",
    description: "Leading porta cabin manufacturer and supplier in UAE with custom solutions",
    type: "website",
    locale: "en_US",
  },
};

export default function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {
  return (
    <html lang="en">
      <body className={`${inter.className} antialiased min-h-screen flex flex-col`}>
        <Header />
        <main className="flex-1">
          {children}
        </main>
        <Footer />
      </body>
    </html>
  );
}
